package org.msh.tb.bd.tbforms.dhis2;

import org.jboss.seam.annotations.In;
import org.msh.tb.application.EtbmanagerApp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by Mauricio on 06/02/2017.
 * Abstract class with common code used on all DHIS2 request services
 */
public abstract class DHIS2RequestService {

    @In
    protected EtbmanagerApp etbmanagerApp;

    /**
     * Returns configured post connection, ready to request DHIS2 server
     * @param apiUrl
     * @param urlParams
     * @param authorization
     * @return
     * @throws IOException
     */
    protected HttpURLConnection getPostConnection(String apiUrl, String urlParams, String authorization) throws IOException {
        // get parameter to send request
        String serverUrl = etbmanagerApp.getConfiguration().getDhis2URL();

        HttpURLConnection conn = null;

        try {
            // mount URL
            String urlString = serverUrl + apiUrl + (urlParams != null ? "?" + urlParams : "");

            // Instantiate URL
            URL url = new URL(urlString);

            // open connection
            conn = (HttpURLConnection) url.openConnection();

            // parametrize Request
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Authorization", authorization);

        } catch (Exception e) {
            if (conn != null) {
                conn.disconnect();
            }

            throw new RuntimeException(e);
        }

        return conn;
    }

    /**
     * Returns configured get connection, ready to request DHIS2 server
     * @param apiUrl
     * @param urlParams
     * @param authorization
     * @return
     * @throws IOException
     */
    protected HttpURLConnection getGetConnection(String apiUrl, String urlParams, String authorization) throws IOException {
        // get parameter to send request
        String serverUrl = etbmanagerApp.getConfiguration().getDhis2URL();

        HttpURLConnection conn = null;

        try {
            // mount URL
            String urlString = serverUrl + apiUrl + (urlParams != null ? "?" + urlParams : "");

            // Instantiate URL
            URL url = new URL(urlString);

            // open connection
            conn = (HttpURLConnection) url.openConnection();

            // parametrize Request
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Authorization", authorization);

        } catch (Exception e) {
            if (conn != null) {
                conn.disconnect();
            }

            throw new RuntimeException(e);
        }

        return conn;
    }

    /**
     * Returns configured post connection, ready to request DHIS2 server
     * @param apiUrl
     * @param urlParams
     * @param authorization
     * @return
     * @throws IOException
     */
    protected HttpURLConnection getPutConnection(String apiUrl, String urlParams, String authorization) throws IOException {
        // get parameter to send request
        String serverUrl = etbmanagerApp.getConfiguration().getDhis2URL();

        HttpURLConnection conn = null;

        try {
            // mount URL
            String urlString = serverUrl + apiUrl + (urlParams != null ? "?" + urlParams : "");

            // Instantiate URL
            URL url = new URL(urlString);

            // open connection
            conn = (HttpURLConnection) url.openConnection();

            // parametrize Request
            conn.setDoOutput(true);
            conn.setRequestMethod("PUT");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Authorization", authorization);

        } catch (Exception e) {
            if (conn != null) {
                conn.disconnect();
            }

            throw new RuntimeException(e);
        }

        return conn;
    }

    /**
     * Checks http code returned by DHIS2 server
     * @param responseCode
     */
    protected void checkHttpCode(int responseCode) {
        if (responseCode != 200) {
            switch (responseCode) {
                case 404:
                    throw new RuntimeException("service not found");
                case 403:
                case 401:
                    throw new RuntimeException("Login failed");
                default:
                    throw new RuntimeException("Failed to request parent server: HTTP error code " + responseCode);
            }
        }
    }

}
